ArrayList <worm> worms = new ArrayList();

boolean debug = false;

void setup() {
  //hint(DISABLE_PERSPECTIVE_CORRECTED_LINES);
  size(500, 500, P2D);

  background(0);
  stroke(255);
  strokeWeight(1);
  
  noFill();
  noCursor();
  smooth(0);

  rectMode(CENTER);
  
  for(int i = 0; i < 2; i++){
  //worms.add(new worm(500,500,new PVector(random(0,width),random(0,height))));
  worms.add(new worm(500,500,new PVector(width/2,height/2)));
  }
  
}

void draw() {

  background(0);
  for( worm w : worms ) {
  w.update();
  w.render();
  }
  
}

void mousePressed() {
  //dragging=!dragging;
  for (worm w : worms) w.generate_worm(1000);
}

//KEYBOARD CONTROLS
/*
void keyPressed() {

  switch(keyCode) {

  case SHIFT:
    debug=!debug;
    break;
  }
}
*/

class rectangle {

  int w;
  int h;
  int l;
  int t;
  float offsetX = 0;
  float offsetY = 0;
  PVector pos;
  PVector worldPos;
  float xspeed, yspeed;
  rectangle parent;
  
  float speed = (0.03);

  rectangle(rectangle P, int W, int H, int L, int T) {

    parent = P;
    w = W;
    h = H;
    l = L;
    t = T;
    pos = new PVector(w/2, h/2);
    worldPos = new PVector(0, 0);
    set_speeds();
  }  

  void update() {

    pos.x += xspeed;
    pos.y += yspeed;

    if (pos.x + l/2 > w || pos.x -l/2 < 0) {
      xspeed *= -1;
    }

    if (pos.y + t/2 > h || pos.y -t/2 < 0) {
      yspeed *= -1;
    }

    if (parent != null) {
      PVector tempPos = new PVector(0, 0);
      tempPos.x += (parent.worldPos.x - pos.x) + w/2;
      tempPos.y += (parent.worldPos.y - pos.y) + h/2;
      worldPos = tempPos;
    } 
    else worldPos = pos;
  }

  void set_speeds(){
  xspeed = random(-speed, speed);
  yspeed = random(-speed, speed);
  }
 

  void render() {
    if(debug)  rect(worldPos.x, worldPos.y, l, t);
    if(parent != null){
    //line(worldPos.x, worldPos.y, parent.worldPos.x, parent.worldPos.y);
    }
    
    point(int(worldPos.x), int(worldPos.y));
   
  }
}

class worm {
  
  int wormWidth;
  int wormHeight;
  
  PVector bRatio;
  ArrayList <rectangle> rectangles = new ArrayList();

  PVector savedPosition = new PVector(width/2,height/2);

  worm(int W, int H, PVector sP) {
    
    savedPosition = sP;
    wormWidth = W;
    wormHeight = H;
    
    generate_worm(1000);
    
  }


  void generate_worm(int wormLength) {

    if(rectangles.size() > 1) savedPosition = rectangles.get(rectangles.size()-1).worldPos;
    rectangles.clear();
    
    int bGCD = gcd(wormWidth, wormHeight);
    bRatio = new PVector(wormWidth/bGCD, wormHeight/bGCD);
    PVector m = new PVector(bRatio.x, bRatio.y);

    rectangles.add(new rectangle(null, wormWidth, wormHeight, (int)random(wormWidth/2, wormWidth), (int)random(wormHeight/2, wormHeight)));
    
    rectangles.get(0).pos = savedPosition;
    
    for (int i = 1; i < wormLength; i++) {
      int x = rectangles.get(i-1).l;
      int y = rectangles.get(i-1).t;
     // float modx = (int)random(10, x-1);
     // float mody = (int)random(10, y-1);
     float modx = x-random(2, 8);
     float mody = y-random(2, 8);
      if (2 > modx || 2 > mody) {
        modx = 2;
        mody = 2;
        break;
      }
      rectangles.add(new rectangle(rectangles.get(i-1), x, y, (int)modx, (int)mody));
    }
     //println("worm:"+rectangles.size()+" - ");
  }

void update(){
   for (rectangle r : rectangles) {
    r.update();
  }
}

void render(){
  
  for (int c = 0; c < rectangles.size(); c++) {
    //stroke(map(c, 0, rectangles.size()-1, 0, 255));
    if(c == rectangles.size()-1) rectangles.get(c).render();
  }  
}


int gcd(int a, int b){
  if (b==0) return a;
  return gcd(b, a%b);
}

}

